// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Objekt.h
//
//	created November 4th,97 by Andreas Warnke
//	geändert 6.5.98 von Andreas Warnke
//



#ifndef Objekt_h_
#define Objekt_h_



// // // // // // // // // // // // // // // //
//
//	include
//

#include "Element.h"
#include "AVLNode.h"



// // // // // // // // // // // // // // // //
//
//	Objekt
//

class Objekt : private Element, protected AVLNode
{
private:
	//	NextID, not used by Client:
	static unsigned int NextID;
	
public:
	//	Objekttyp:
	unsigned int Typ;
	unsigned int GetID () const;
	
	//	SpielerID:
	unsigned int BelongsTo;

	//	Position;
	int XPos, YPos;
	int MoveToX, MoveToY;
	
	//	Letzter Zug, bei dem das Objekt bewegt wurde:
	bigtime_t BusyTill;
	
public:
	//	Konstruktoren:
	Objekt ();
	Objekt (
		//	ID wird aus NextID ermittelt.
		unsigned int inType,
		unsigned int inOwner,
		int inX,
		int inY,
		bigtime_t inBusyTill = 1);
	Objekt (
		unsigned int inID,
		unsigned int inType,
		unsigned int inOwner,
		int inX,
		int inY,
		bigtime_t inBusyTill);
	//	Copy-Konstruktor.
	Objekt ( const Objekt & inOriginal );
	
	//	Destruktor:
	virtual ~Objekt ();
};



// // // // // // // // // // // // // // // //
//	
//	Objekttyp:
//

//	0x00	kein Objekt
#define Obj_NoObject 0x00

//	0x10 - 0x1f not used by the server
//	0x10	Mehrere Objekte verschiedener Typen
#define Obj_Mixed 0x10	

//	0x20	Dorf
#define Obj_Dorf 0x20

//	0x30	Figur 1
#define Obj_Figur 0x30

//	0x40 - 0xff	not used by the Server

//	Bitmasken:
#define Obj_TypeMask 0x3f
#define Obj_BusyMask 0x80



#endif



//
//	Ende.
//
// // // // // // // // // // // // // // // //